/* The following code was generated by JFlex 1.4.3 on 12/6/12 5:04 PM */

// $codepro.audit.disable
/**
 * Aptana Studio
 * Copyright (c) 2005-2012 by Appcelerator, Inc. All Rights Reserved.
 * Licensed under the terms of the GNU Public License (GPL) v3 (with exceptions).
 * Please see the license.html included with this distribution for details.
 * Any modifications to this file must keep this entire header intact.
 */
package com.aptana.dtd.core.parsing;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.internal.utils.StringPool;

import beaver.Scanner;
import beaver.Symbol;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 12/6/12 5:04 PM from the specification file
 * <tt>/Users/cwilliams/repos/studio3/plugins/com.aptana.dtd.core/parsing/DTD.flex</tt>
 */
public class DTDScanner extends Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\1\1\0\1\1\1\1\22\0\1\1\1\7\1\4"+
    "\1\31\1\0\1\53\1\13\1\5\1\45\1\47\1\50\1\51\1\52"+
    "\1\10\1\2\1\0\12\2\1\3\1\14\1\6\1\0\1\11\1\12"+
    "\1\0\1\17\1\44\1\36\1\34\1\24\1\32\1\42\1\3\1\22"+
    "\1\3\1\43\1\21\1\25\1\26\1\30\1\35\1\40\1\37\1\23"+
    "\1\20\1\41\2\3\1\33\1\27\1\3\1\15\1\54\1\16\1\0"+
    "\1\3\1\0\32\3\1\0\1\46\uff83\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\3\1\1\5\1\6"+
    "\1\1\1\7\1\1\5\4\1\1\2\4\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\0\1\17\1\1"+
    "\1\0\1\1\4\0\2\4\1\20\7\4\4\0\2\4"+
    "\1\0\1\21\4\0\1\22\1\23\1\24\11\4\4\0"+
    "\2\4\5\0\1\25\11\4\4\0\2\4\5\0\1\4"+
    "\1\26\2\4\1\27\3\4\1\30\4\0\1\4\1\31"+
    "\5\0\1\4\1\32\1\33\1\34\1\4\1\35\2\4"+
    "\1\0\1\36\2\0\1\37\1\40\4\0\1\41\1\4"+
    "\1\42\1\4\1\0\1\43\3\0\1\44\1\0\1\45"+
    "\1\46\1\47\1\50\1\0\1\51\1\52\1\0\1\53"+
    "\1\54";

  private static int [] zzUnpackAction() {
    int [] result = new int[162];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\55\0\132\0\207\0\264\0\341\0\u010e\0\u013b"+
    "\0\55\0\55\0\u0168\0\55\0\u0195\0\u01c2\0\u01ef\0\u021c"+
    "\0\u0249\0\u0276\0\u02a3\0\u02d0\0\u02fd\0\55\0\55\0\55"+
    "\0\55\0\55\0\55\0\u0168\0\u032a\0\55\0\u032a\0\u0357"+
    "\0\u0357\0\u0384\0\u03b1\0\u03de\0\u040b\0\u0438\0\u0465\0\u0492"+
    "\0\u04bf\0\u04ec\0\u0519\0\u0546\0\u0573\0\u05a0\0\u05cd\0\u05fa"+
    "\0\u0627\0\u0654\0\u0681\0\u06ae\0\u06db\0\u0708\0\55\0\u0735"+
    "\0\u0762\0\u078f\0\u07bc\0\55\0\55\0\264\0\u07e9\0\u0816"+
    "\0\u0843\0\u0870\0\u089d\0\u08ca\0\u08f7\0\u0924\0\u0951\0\u097e"+
    "\0\u09ab\0\u09d8\0\u0a05\0\u0a32\0\u0a5f\0\u0a8c\0\u0ab9\0\u0ae6"+
    "\0\u0b13\0\u0b40\0\55\0\u0b6d\0\u0b9a\0\u0bc7\0\u0bf4\0\u0c21"+
    "\0\u0c4e\0\u0c7b\0\u0ca8\0\u0cd5\0\u0d02\0\u0d2f\0\u0d5c\0\u0d89"+
    "\0\u0db6\0\u0de3\0\u0e10\0\u0e3d\0\u0e6a\0\u0e97\0\u0ec4\0\u0ef1"+
    "\0\u0f1e\0\u0f4b\0\u0f78\0\264\0\u0fa5\0\u0fd2\0\u0fff\0\264"+
    "\0\u102c\0\u1059\0\u1086\0\u10b3\0\u10e0\0\264\0\u110d\0\u113a"+
    "\0\u1167\0\u1194\0\u11c1\0\u11ee\0\264\0\264\0\264\0\u121b"+
    "\0\264\0\u1248\0\u1275\0\u12a2\0\55\0\u12cf\0\u12fc\0\264"+
    "\0\55\0\u1329\0\u1356\0\u1383\0\u13b0\0\264\0\u13dd\0\u140a"+
    "\0\u1437\0\u1464\0\55\0\u1491\0\u14be\0\u14eb\0\55\0\u1518"+
    "\0\264\0\264\0\264\0\55\0\u1545\0\55\0\55\0\u1572"+
    "\0\55\0\55";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[162];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\2"+
    "\1\4\1\11\1\12\1\13\1\2\1\14\1\15\1\16"+
    "\2\5\1\17\1\20\1\21\1\5\1\22\2\5\1\23"+
    "\3\5\1\24\1\25\6\5\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\2\56\0\1\3\55\0\2\4"+
    "\4\0\1\4\6\0\12\4\1\0\13\4\12\0\2\5"+
    "\4\0\1\5\6\0\12\5\1\0\13\5\10\0\4\35"+
    "\1\36\47\35\1\37\5\40\1\36\46\40\1\41\7\0"+
    "\1\42\2\0\1\43\45\0\1\44\13\0\12\44\1\0"+
    "\13\44\26\0\1\45\40\0\2\5\4\0\1\5\6\0"+
    "\7\5\1\46\2\5\1\0\13\5\12\0\2\5\4\0"+
    "\1\5\6\0\7\5\1\47\2\5\1\0\2\5\1\50"+
    "\5\5\1\51\2\5\12\0\2\5\4\0\1\5\6\0"+
    "\10\5\1\52\1\5\1\0\13\5\12\0\2\5\4\0"+
    "\1\5\6\0\6\5\1\53\1\54\2\5\1\0\13\5"+
    "\12\0\2\5\4\0\1\5\6\0\6\5\1\55\2\5"+
    "\1\56\1\0\2\5\1\57\10\5\32\0\1\60\7\0"+
    "\1\61\2\0\1\62\1\0\1\63\17\0\2\5\4\0"+
    "\1\5\6\0\12\5\1\0\7\5\1\64\3\5\12\0"+
    "\2\5\4\0\1\5\6\0\12\5\1\0\2\5\1\65"+
    "\10\5\10\0\4\35\1\36\50\35\5\40\1\36\47\40"+
    "\10\0\1\66\4\0\1\67\1\0\1\70\4\0\1\71"+
    "\1\0\1\72\26\0\12\43\1\73\42\43\2\0\2\44"+
    "\4\0\1\44\3\0\1\74\2\0\12\44\1\0\13\44"+
    "\21\0\1\75\45\0\2\5\4\0\1\5\6\0\10\5"+
    "\1\76\1\5\1\0\13\5\12\0\2\5\4\0\1\5"+
    "\6\0\12\5\1\0\4\5\1\77\6\5\12\0\2\5"+
    "\4\0\1\5\6\0\12\5\1\0\5\5\1\100\5\5"+
    "\12\0\2\5\4\0\1\5\6\0\7\5\1\101\2\5"+
    "\1\0\13\5\12\0\2\5\4\0\1\5\6\0\4\5"+
    "\1\102\5\5\1\0\13\5\12\0\2\5\4\0\1\5"+
    "\6\0\12\5\1\0\3\5\1\103\7\5\12\0\2\5"+
    "\4\0\1\5\6\0\1\5\1\104\10\5\1\0\13\5"+
    "\12\0\2\5\4\0\1\5\6\0\1\5\1\105\10\5"+
    "\1\0\13\5\12\0\2\5\4\0\1\5\6\0\1\5"+
    "\1\106\10\5\1\0\13\5\12\0\2\5\4\0\1\5"+
    "\6\0\1\107\11\5\1\0\13\5\35\0\1\110\51\0"+
    "\1\111\70\0\1\112\42\0\1\113\32\0\2\5\4\0"+
    "\1\5\6\0\12\5\1\0\12\5\1\114\12\0\2\5"+
    "\4\0\1\5\6\0\1\115\11\5\1\0\13\5\20\0"+
    "\1\116\64\0\1\117\55\0\1\120\4\0\1\121\56\0"+
    "\1\122\24\0\11\43\1\123\1\73\42\43\2\0\2\5"+
    "\4\0\1\5\6\0\2\5\1\124\7\5\1\0\13\5"+
    "\12\0\2\5\4\0\1\5\6\0\5\5\1\125\4\5"+
    "\1\0\13\5\12\0\2\5\4\0\1\5\6\0\11\5"+
    "\1\126\1\0\13\5\12\0\2\5\4\0\1\5\6\0"+
    "\1\5\1\127\10\5\1\0\13\5\12\0\2\5\4\0"+
    "\1\5\6\0\1\5\1\130\10\5\1\0\13\5\12\0"+
    "\2\5\4\0\1\5\6\0\3\5\1\131\6\5\1\0"+
    "\13\5\12\0\2\5\4\0\1\5\6\0\11\5\1\132"+
    "\1\0\13\5\12\0\2\5\4\0\1\5\6\0\1\133"+
    "\11\5\1\0\13\5\12\0\2\5\4\0\1\5\6\0"+
    "\1\5\1\134\10\5\1\0\13\5\45\0\1\135\52\0"+
    "\1\136\55\0\1\137\60\0\1\140\16\0\2\5\4\0"+
    "\1\5\6\0\2\5\1\141\7\5\1\0\13\5\12\0"+
    "\2\5\4\0\1\5\6\0\1\5\1\142\10\5\1\0"+
    "\13\5\10\0\10\116\1\143\44\116\20\0\1\144\60\0"+
    "\1\145\50\0\1\146\54\0\1\147\36\0\2\5\4\0"+
    "\1\5\6\0\12\5\1\0\7\5\1\150\3\5\12\0"+
    "\2\5\4\0\1\5\6\0\12\5\1\0\1\151\12\5"+
    "\12\0\2\5\4\0\1\5\6\0\12\5\1\0\5\5"+
    "\1\152\5\5\12\0\2\5\4\0\1\5\6\0\5\5"+
    "\1\153\4\5\1\0\13\5\12\0\2\5\4\0\1\5"+
    "\6\0\10\5\1\154\1\5\1\0\13\5\12\0\2\5"+
    "\4\0\1\5\6\0\1\5\1\155\10\5\1\0\13\5"+
    "\12\0\2\5\4\0\1\5\6\0\12\5\1\0\11\5"+
    "\1\156\1\5\12\0\2\5\4\0\1\5\6\0\1\5"+
    "\1\157\10\5\1\0\13\5\12\0\2\5\4\0\1\5"+
    "\6\0\1\160\11\5\1\0\13\5\31\0\1\161\57\0"+
    "\1\162\47\0\1\163\76\0\1\164\15\0\2\5\4\0"+
    "\1\5\6\0\3\5\1\165\6\5\1\0\13\5\12\0"+
    "\2\5\4\0\1\5\6\0\1\166\11\5\1\0\13\5"+
    "\10\0\10\116\1\167\44\116\21\0\1\170\60\0\1\171"+
    "\51\0\1\172\51\0\1\173\37\0\2\5\4\0\1\5"+
    "\6\0\12\5\1\0\2\5\1\174\10\5\12\0\2\5"+
    "\4\0\1\5\6\0\4\5\1\175\5\5\1\0\13\5"+
    "\12\0\2\5\4\0\1\5\6\0\5\5\1\176\4\5"+
    "\1\0\13\5\12\0\2\5\4\0\1\5\6\0\6\5"+
    "\1\177\3\5\1\0\13\5\12\0\2\5\4\0\1\5"+
    "\6\0\3\5\1\200\4\5\1\201\1\5\1\0\13\5"+
    "\12\0\2\5\4\0\1\5\6\0\5\5\1\202\4\5"+
    "\1\0\13\5\12\0\2\5\4\0\1\5\6\0\3\5"+
    "\1\203\6\5\1\0\13\5\32\0\1\204\66\0\1\205"+
    "\40\0\1\206\56\0\1\207\34\0\2\5\4\0\1\5"+
    "\6\0\12\5\1\0\4\5\1\210\6\5\10\0\10\116"+
    "\1\167\1\211\43\116\22\0\1\212\56\0\1\213\50\0"+
    "\1\214\54\0\1\215\36\0\2\5\4\0\1\5\6\0"+
    "\5\5\1\216\4\5\1\0\13\5\12\0\2\5\4\0"+
    "\1\5\6\0\5\5\1\217\4\5\1\0\13\5\12\0"+
    "\2\5\4\0\1\5\6\0\7\5\1\220\2\5\1\0"+
    "\13\5\12\0\2\5\4\0\1\5\6\0\11\5\1\221"+
    "\1\0\13\5\34\0\1\222\47\0\1\223\74\0\1\224"+
    "\40\0\1\225\57\0\1\226\55\0\1\227\47\0\1\230"+
    "\34\0\2\5\4\0\1\5\6\0\4\5\1\231\5\5"+
    "\1\0\13\5\12\0\2\5\4\0\1\5\6\0\4\5"+
    "\1\232\5\5\1\0\13\5\12\0\2\5\4\0\1\5"+
    "\6\0\7\5\1\233\2\5\1\0\13\5\44\0\1\234"+
    "\44\0\1\235\50\0\1\236\54\0\1\237\64\0\1\240"+
    "\60\0\1\241\46\0\1\242\26\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[5535];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\6\1\2\11\1\1\1\11\11\1\6\11"+
    "\1\1\1\0\1\11\1\1\1\0\1\1\4\0\12\1"+
    "\4\0\2\1\1\0\1\11\4\0\2\11\12\1\4\0"+
    "\2\1\5\0\1\11\11\1\4\0\2\1\5\0\11\1"+
    "\4\0\2\1\5\0\10\1\1\0\1\11\2\0\1\1"+
    "\1\11\4\0\4\1\1\0\1\11\3\0\1\11\1\0"+
    "\3\1\1\11\1\0\2\11\1\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[162];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	// last token used for look behind. Also needed when implementing the ITokenScanner interface
	private Symbol _lastToken;
	
	private List<Symbol> tokenQueue = new ArrayList<Symbol>();
	
	private static final Pattern ENTITY = Pattern.compile("%([^; \\t\\n]+);"); //$NON-NLS-1$
	private Map<String, String> _entities;
	
	private StringPool _stringPool;

	public DTDScanner()
	{
		this((Reader) null);
	}

	public Symbol getLastToken()
	{
		return _lastToken;
	}

	private Symbol newToken(DTDTokenType type, Object value)
	{
		return newToken(type.getIndex(), value);
	}

	private Symbol newToken(DTDTokenType type)
	{
		return newToken(type.getIndex(), null);
	}
	
	private String pool(String value)
	{
		return _stringPool.add(value);
	}

	private Symbol newToken(short id, Object value)
	{
		return new Symbol(id, yychar, yychar + yylength() - 1, value);
	}

	public Symbol nextToken() throws java.io.IOException, Scanner.Exception
	{
		if (!tokenQueue .isEmpty())
		{
			return tokenQueue.remove(0);
		}
		
		try
		{
			// get next token
			_lastToken = yylex();
		} 
		catch (Scanner.Exception e)
		{
			// create default token type
			String text = yytext();
			int end = yychar + text.length() - 1;

			_lastToken = new Symbol(DTDTokenType.EOF.getIndex(), yychar, end, text);
		}

		return _lastToken;
	}

	public void setSource(String source)
	{
		yyreset(new StringReader(source));

		_stringPool = new StringPool();

		// clear last token
		_lastToken = null;
	}
	
	String getValue(String key)
	{
		String result = null;

		if (this._entities != null)
		{
			result = this._entities.get(key);
		}

		return result;
	}
	
	void register(String key, String value)
	{
		if (this._entities == null)
		{
			this._entities = new HashMap<String, String>();
		}

		// According to the XML 1.1 Specification in Section 4.2:
		// If the same entity is declared more than once, the first declaration encountered is binding;
		// at user option, an XML processor may issue a warning if entities are declared multiple times.
		if (this._entities.containsKey(key) == false)
		{
			this._entities.put(key, value);
		}
	}
	
	Symbol registered(String peRef) throws IOException, Exception
	{
		// grab key minus the leading '%' and trailing ';'
		String key = peRef.substring(1, peRef.length() - 1);

		// grab entity's value
		String text = getValue(key);

		if (text == null)
		{
			return newToken(Terminals.PE_REF, peRef);
		}

		// create new scanner
		// We need to continue to scan tokens until EOF, not just one token!
		DTDScanner nested = new DTDScanner();
		nested.setSource(text);
		nested._entities = _entities;
		Symbol s;
		while (true)
		{
			s = nested.nextToken();
			if (s.getId() == Terminals.EOF)
			{
				break;
			}
			s = new Symbol(s.getId(), s.getStart() + yychar, s.getEnd() + yychar, s.value);
			tokenQueue.add(s);
		}

		return tokenQueue.remove(0);
	}
	
	Symbol handleString(String text)
	{
		StringBuffer buffer = new StringBuffer();
		Matcher m = ENTITY.matcher(text);

		while (m.find())
		{
			String name = m.group(1);
			String newText = this.getValue(name);

			if (newText == null)
			{
				newText = name;
			}

			m.appendReplacement(buffer, newText);
		}

		m.appendTail(buffer);

		return newToken(Terminals.STRING, pool(buffer.toString()));
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DTDScanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public DTDScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 132) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol yylex() throws java.io.IOException, Scanner.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 2: 
          { /* ignore */
          }
        case 45: break;
        case 36: 
          { return newToken(DTDTokenType.ENTITY);
          }
        case 46: break;
        case 7: 
          { return newToken(DTDTokenType.LBRACKET);
          }
        case 47: break;
        case 17: 
          { return newToken(DTDTokenType.SECTION_START);
          }
        case 48: break;
        case 9: 
          { return newToken(DTDTokenType.PIPE);
          }
        case 49: break;
        case 20: 
          { return newToken(DTDTokenType.ANY, pool("ANY"));
          }
        case 50: break;
        case 41: 
          { return newToken(DTDTokenType.ATTLIST);
          }
        case 51: break;
        case 16: 
          { return newToken(DTDTokenType.ID_TYPE, pool("ID"));
          }
        case 52: break;
        case 18: 
          { return registered(yytext());
          }
        case 53: break;
        case 4: 
          { return newToken(DTDTokenType.NAME, pool(yytext()));
          }
        case 54: break;
        case 40: 
          { return newToken(DTDTokenType.IMPLIED, pool("#IMPLIED"));
          }
        case 55: break;
        case 43: 
          { return newToken(DTDTokenType.REQUIRED, pool("#REQUIRED"));
          }
        case 56: break;
        case 33: 
          { return newToken(DTDTokenType.INCLUDE, pool("INCLUDE"));
          }
        case 57: break;
        case 44: 
          { return newToken(DTDTokenType.NOTATION);
          }
        case 58: break;
        case 6: 
          { return newToken(DTDTokenType.QUESTION);
          }
        case 59: break;
        case 24: 
          { return newToken(DTDTokenType.NDATA, pool("NDATA"));
          }
        case 60: break;
        case 8: 
          { return newToken(DTDTokenType.LPAREN);
          }
        case 61: break;
        case 3: 
          { return newToken(DTDTokenType.NMTOKEN, pool(yytext()));
          }
        case 62: break;
        case 39: 
          { return newToken(DTDTokenType.NOTATION_TYPE, pool("NOTATION"));
          }
        case 63: break;
        case 15: 
          { return handleString(yytext());
          }
        case 64: break;
        case 25: 
          { return newToken(DTDTokenType.CDATA_TYPE, pool("CDATA"));
          }
        case 65: break;
        case 31: 
          { return newToken(DTDTokenType.PUBLIC, pool("PUBLIC"));
          }
        case 66: break;
        case 29: 
          { return newToken(DTDTokenType.ENTITY_TYPE, pool("ENTITY"));
          }
        case 67: break;
        case 5: 
          { return newToken(DTDTokenType.GREATER_THAN);
          }
        case 68: break;
        case 26: 
          { return newToken(DTDTokenType.IDREFS_TYPE, pool("IDREFS"));
          }
        case 69: break;
        case 21: 
          { return newToken(Terminals.PI, pool(yytext()));
          }
        case 70: break;
        case 35: 
          { return newToken(DTDTokenType.PCDATA, pool("#PCDATA"));
          }
        case 71: break;
        case 34: 
          { return newToken(DTDTokenType.NMTOKEN_TYPE, pool("NMTOKEN"));
          }
        case 72: break;
        case 22: 
          { return newToken(DTDTokenType.IDREF_TYPE, pool("IDREF"));
          }
        case 73: break;
        case 38: 
          { return newToken(DTDTokenType.NMTOKENS_TYPE, pool("NMTOKENS"));
          }
        case 74: break;
        case 1: 
          { // make sure we reset the lexer state for next (potential) scan
				yybegin(YYINITIAL);
				throw new Scanner.Exception("Unexpected character '" + yytext() + "' around offset " + yychar);
          }
        case 75: break;
        case 12: 
          { return newToken(DTDTokenType.PLUS);
          }
        case 76: break;
        case 42: 
          { return newToken(DTDTokenType.ELEMENT);
          }
        case 77: break;
        case 14: 
          { return newToken(DTDTokenType.PERCENT);
          }
        case 78: break;
        case 13: 
          { return newToken(DTDTokenType.COMMA);
          }
        case 79: break;
        case 28: 
          { return newToken(DTDTokenType.SYSTEM, pool("SYSTEM"));
          }
        case 80: break;
        case 37: 
          { return newToken(DTDTokenType.ENTITIES_TYPE, pool("ENTITIES"));
          }
        case 81: break;
        case 32: 
          { return newToken(Terminals.COMMENT, pool(yytext()));
          }
        case 82: break;
        case 27: 
          { return newToken(DTDTokenType.IGNORE, pool("IGNORE"));
          }
        case 83: break;
        case 10: 
          { return newToken(DTDTokenType.RPAREN);
          }
        case 84: break;
        case 30: 
          { return newToken(DTDTokenType.FIXED, pool("#FIXED"));
          }
        case 85: break;
        case 23: 
          { return newToken(DTDTokenType.EMPTY, pool("EMPTY"));
          }
        case 86: break;
        case 11: 
          { return newToken(DTDTokenType.STAR);
          }
        case 87: break;
        case 19: 
          { return newToken(DTDTokenType.SECTION_END);
          }
        case 88: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              { 	return newToken(Terminals.EOF, "end-of-file");
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
